<?php
// ip-check.php
function isIranIP($ip) {
    $data = @file_get_contents("http://ip-api.com/json/{$ip}?fields=countryCode");
    if ($data) {
        $json = json_decode($data, true);
        return isset($json['countryCode']) && $json['countryCode'] === 'IR';
    }
    return false;
}

$user_ip = $_SERVER['REMOTE_ADDR'];

if (isIranIP($user_ip)) {
    // اگر IP ایران است، مستقیم برو به py.php
    header("Location: py.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>تشخیص IP ایران</title>
<style>
    body {
        font-family: Vazirmatn, sans-serif;
        background: linear-gradient(180deg,#f7f7f7,#eaeaea);
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
        padding: 15px; /* برای فضای داخلی در موبایل */
    }
    .card {
        background: rgba(255,255,255,0.75);
        backdrop-filter: blur(15px);
        padding: 25px;
        border-radius: 15px;
        text-align: center;
        box-shadow: 0 8px 25px rgba(0,0,0,0.12);
        max-width: 420px;
        width: 100%;
    }
    h2 {
        color: #d32f2f;
        margin-bottom: 15px;
        font-size: 1.4rem;
    }
    p {
        font-size: 1rem;
        color: #333;
        line-height: 1.6;
    }
    button {
        background: #00bfa5;
        border: none;
        color: white;
        font-size: 1rem;
        padding: 12px 25px;
        margin-top: 20px;
        border-radius: 8px;
        cursor: pointer;
        width: 100%;
        transition: all 0.3s;
    }
    button:hover {
        background: #009c88;
    }
    @media (max-width: 480px) { /* تنظیم برای موبایل کوچک */
        h2 { font-size: 1.2rem; }
        p { font-size: 0.95rem; }
        button { font-size: 0.95rem; padding: 10px; }
    }
</style>
</head>
<body>
<div class="card">
    <h2>🚫 دسترسی محدود</h2>
    <p>
        سیستم تشخیص داد که IP شما ایرانی نیست.<br>
        لطفاً <strong>فیلترشکن خود را خاموش کنید</strong> و سپس دکمه زیر را فشار دهید تا دوباره بررسی شود.
    </p>
    <button onclick="location.reload()">🔄 رفرش</button>
</div>
</body>
</html>
